#ifndef __SoundManager_h__
#define __SoundManager_h__

#include <stdio.h>
#include <stdlib.h>
#if defined(WIN32) || defined(_WIN64) || defined(__WATCOMC__)
    #include <windows.h>
    #include <conio.h>
#else
    #include <wincompat.h>
#endif

#include <fmod.h>
#include <fmod_errors.h>

#include <list>

struct sFadeSound {
   int   channel;
   int   targetvol;
   float speed;
   float f_vol;
   int   signval;
};

typedef std::list<sFadeSound> FadeSoundList;

enum SampleID {
   SAM_FIRE=0,SAM_EXPLOSION,SAM_JUMP,SAM_DEATH,SAM_CHEERS,SAM_BUZZER,SAM_BONUSCAPTURE,
   SAM_METALLICA,
   SAM_LAST
};

// Bu sinif ses ile ilgili tum islemleri gerceklestirmekten sorumlu.
// init() fonksiyonu icerisinde sisteme yuklenen ses dosyalarini
// playXXX() yordamlari ile caldirabiliyorsunuz. Ayni zamanda ses seviyesini
// ayarlama, sesi kisma gibi bazi alt seviye fonksiyonlarda destekleniyor.

class SoundManager {

public:
   SoundManager();
   ~SoundManager();

   void init();
   void destroy();
   void update(float dt);
   int  playSample(int sid,int channel=FSOUND_FREE,bool looped=false);
   void mute(bool m) { mutesnd = m; };
   void setMasterVolume(unsigned char mvol);
   
   void playFireSound();
   void playExplosionSound();
   void playJumpSound();
   void playDeathSound();
   void playCheersSound();
   void playBuzzerSound();
   void playBonusCaptureSound();
   void playMetallica();

protected:

   void fadeSound(int channel,int fromvol,int tovol,float speed);

   FSOUND_SAMPLE *samples[SAM_LAST];
   FadeSoundList fadeList;

   bool playing_ingamebackground;
   bool playing_menubackground;
   int  ingamebackground_channel;
   int  menubackground_channel;

   bool mutesnd;
   unsigned char maxvolume;
   int moveChannelId;


};


#endif